# -*- coding: utf-8 -*-
from setuptools import setup

setup(
    name='datadog',
    version='0.44.0',
    description='The Datadog Python library',
    long_description='# The Datadog Python library\n\n[![Unit Tests](https://dev.azure.com/datadoghq/datadogpy/_apis/build/status/DataDog.datadogpy.unit?branchName=master)](https://dev.azure.com/datadoghq/datadogpy/_build/latest?definitionId=10&branchName=master)\n[![Integration Tests](https://dev.azure.com/datadoghq/datadogpy/_apis/build/status/DataDog.datadogpy.integration?branchName=master)](https://dev.azure.com/datadoghq/datadogpy/_build/latest?definitionId=13&branchName=master)\n[![Documentation Status](https://readthedocs.org/projects/datadogpy/badge/?version=latest)](https://readthedocs.org/projects/datadogpy/?badge=latest)\n[![PyPI - Version](https://img.shields.io/pypi/v/datadog.svg)](https://pypi.org/project/datadog)\n[![PyPI - Downloads](https://pepy.tech/badge/datadog)](https://pepy.tech/project/datadog)\n\nThe Datadog Python Library is a collection of tools suitable for inclusion in existing Python projects or for the development of standalone scripts. It provides an abstraction on top of Datadog\'s raw HTTP interface and the Agent\'s DogStatsD metrics aggregation server, to interact with Datadog and efficiently report events and metrics.\n\n- Library Documentation: https://datadogpy.readthedocs.io/en/latest/\n- HTTP API Documentation: https://docs.datadoghq.com/api/\n- DatadogHQ: https://datadoghq.com\n\nSee [CHANGELOG.md](https://github.com/DataDog/datadogpy/blob/master/CHANGELOG.md) for changes.\n\n## Installation\n\nTo install from pip:\n\n    pip install datadog\n\nTo install from source:\n\n    python setup.py install\n\n## Datadog API\n\nTo support all Datadog HTTP APIs, a generated library is\navailable which will expose all the endpoints:\n[datadog-api-client-python](https://github.com/DataDog/datadog-api-client-python).\n\nFind below a working example for submitting an event to your Event Stream:\n\n```python\nfrom datadog import initialize, api\n\noptions = {\n    "api_key": "<YOUR_API_KEY>",\n    "app_key": "<YOUR_APP_KEY>",\n}\n\ninitialize(**options)\n\ntitle = "Something big happened!"\ntext = "And let me tell you all about it here!"\ntags = ["version:1", "application:web"]\n\napi.Event.create(title=title, text=text, tags=tags)\n```\n\n**Consult the full list of supported Datadog API endpoints with working code examples in [the Datadog API documentation](https://docs.datadoghq.com/api/latest/?code-lang=python).**\n\n**Note**: The full list of available Datadog API endpoints is also available in the [Datadog Python Library documentation](https://datadogpy.readthedocs.io/en/latest/)\n\n#### Environment Variables\n\nAs an alternate method to using the `initialize` function with the `options` parameters, set the environment variables `DATADOG_API_KEY` and `DATADOG_APP_KEY` within the context of your application.\n\nIf `DATADOG_API_KEY` or `DATADOG_APP_KEY` are not set, the library attempts to fall back to Datadog\'s APM environment variable prefixes: `DD_API_KEY` and `DD_APP_KEY`.\n\n```python\nfrom datadog import initialize, api\n\n# Assuming you\'ve set `DD_API_KEY` and `DD_APP_KEY` in your env,\n# initialize() will pick it up automatically\ninitialize()\n\ntitle = "Something big happened!"\ntext = "And let me tell you all about it here!"\ntags = ["version:1", "application:web"]\n\napi.Event.create(title=title, text=text, tags=tags)\n```\n\nIn development, you can disable any `statsd` metric collection using `DD_DOGSTATSD_DISABLE=True` (or any not-empty value).\n\n## DogStatsD\n\nIn order to use DogStatsD metrics, the Agent must be [running and available](https://docs.datadoghq.com/developers/dogstatsd/?code-lang=python).\n\n### Instantiate the DogStatsD client with UDP\n\nOnce the Datadog Python Library is installed, instantiate the StatsD client using UDP in your code:\n\n```python\nfrom datadog import initialize, statsd\n\noptions = {\n    "statsd_host": "127.0.0.1",\n    "statsd_port": 8125,\n}\n\ninitialize(**options)\n```\n\nSee the full list of available [DogStatsD client instantiation parameters](https://docs.datadoghq.com/developers/dogstatsd/?code-lang=python#client-instantiation-parameters).\n\n#### Instantiate the DogStatsd client with UDS\n\nOnce the Datadog Python Library is installed, instantiate the StatsD client using UDS in your code:\n```python\n\nfrom datadog import initialize, statsd\n\noptions = {\n    "statsd_socket_path": PATH_TO_SOCKET,\n}\n\ninitialize(**options)\n```\n\n#### Origin detection over UDP and UDS\n\nOrigin detection is a method to detect which pod `DogStatsD` packets are coming from in order to add the pod\'s tags to the tag list.\nThe `DogStatsD` client attaches an internal tag, `entity_id`. The value of this tag is the content of the `DD_ENTITY_ID` environment variable if found, which is the pod\'s UID. The Datadog Agent uses this tag to add container tags to the metrics. To avoid overwriting this global tag, make sure to only `append` to the `constant_tags` list.\n\nTo enable origin detection over UDP, add the following lines to your application manifest\n```yaml\nenv:\n  - name: DD_ENTITY_ID\n    valueFrom:\n      fieldRef:\n        fieldPath: metadata.uid\n```\n\n### Usage\n#### Metrics\n\nAfter the client is created, you can start sending custom metrics to Datadog. See the dedicated [Metric Submission: DogStatsD documentation](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python) to see how to submit all supported metric types to Datadog with working code examples:\n\n* [Submit a COUNT metric](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#count).\n* [Submit a GAUGE metric](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#gauge).\n* [Submit a SET metric](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#set)\n* [Submit a HISTOGRAM metric](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#histogram)\n* [Submit a TIMER metric](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#timer)\n* [Submit a DISTRIBUTION metric](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#distribution)\n\nSome options are supported when submitting metrics, like [applying a Sample Rate to your metrics](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#metric-submission-options) or [tagging your metrics with your custom tags](https://docs.datadoghq.com/metrics/dogstatsd_metrics_submission/?code-lang=python#metric-tagging).\n\n#### Events\n\nAfter the client is created, you can start sending events to your Datadog Event Stream. See the dedicated [Event Submission: DogStatsD documentation](https://docs.datadoghq.com/events/guides/dogstatsd/?code-lang=python) to see how to submit an event to your Datadog Event Stream.\n\n#### Service Checks\n\nAfter the client is created, you can start sending Service Checks to Datadog. See the dedicated [Service Check Submission: DogStatsD documentation](https://docs.datadoghq.com/developers/service_checks/dogstatsd_service_checks_submission/?code-lang=python) to see how to submit a Service Check to Datadog.\n\n### Monitoring this client\n\nThis client automatically injects telemetry about itself in the DogStatsD stream.\nThose metrics will not be counted as custom and will not be billed. This feature can be disabled using the `statsd.disable_telemetry()` method.\n\nSee [Telemetry documentation](https://docs.datadoghq.com/developers/dogstatsd/high_throughput/?code-lang=python#client-side-telemetry) to learn more about it.\n\n### Benchmarks\n\n_Note: You will need to install `psutil` package before running the benchmarks._\n\nIf you would like to get an approximate idea on the throughput that your DogStatsD library\ncan handle on your system, you can run the included local benchmark code:\n\n```sh-session\n$ # Python 2 Example\n$ python2 -m unittest -vvv tests.performance.test_statsd_throughput\n\n$ # Python 3 Example\n$ python3 -m unittest -vvv tests.performance.test_statsd_throughput\n```\n\nYou can also add set `BENCHMARK_*` to customize the runs:\n```sh-session\n$ # Example #1\n$ BENCHMARK_NUM_RUNS=10 BENCHMARK_NUM_THREADS=1 BENCHMARK_NUM_DATAPOINTS=5000 BENCHMARK_TRANSPORT="UDP" python2 -m unittest -vvv tests.performance.test_statsd_throughput\n\n$ # Example #2\n$ BENCHMARK_NUM_THREADS=10 BENCHMARK_TRANSPORT="UDS" python3 -m unittest -vvv tests.performance.test_statsd_throughput\n```\n\n## Maximum packets size in high-throughput scenarios\n\nIn order to have the most efficient use of this library in high-throughput scenarios,\ndefault values for the maximum packets size have already been set for both UDS (8192 bytes)\nand UDP (1432 bytes) in order to have the best usage of the underlying network.\nHowever, if you perfectly know your network and you know that a different value for the maximum packets\nsize should be used, you can set it with the parameter `max_buffer_len`. Example:\n\n```python\nfrom datadog import initialize\n\noptions = {\n    "api_key": "<YOUR_API_KEY>",\n    "app_key": "<YOUR_APP_KEY>",\n    "max_buffer_len": 4096,\n}\n\ninitialize(**options)\n```\n\n## Thread Safety\n\n`DogStatsD` and `ThreadStats` are thread-safe.\n',
    author_email='"Datadog, Inc." <dev@datadoghq.com>',
    classifiers=[
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
    ],
    install_requires=[
        'configparser<5; python_version < "3.0"',
        'requests>=2.6.0',
        'typing; python_version < "3.5"',
    ],
    entry_points={
        'console_scripts': [
            'dog = datadog.dogshell:main',
            'dogshell = datadog.dogshell:main',
            'dogshellwrap = datadog.dogshell.wrap:main',
            'dogwrap = datadog.dogshell.wrap:main',
        ],
    },
    packages=[
        'datadog',
        'datadog.api',
        'datadog.dogshell',
        'datadog.dogstatsd',
        'datadog.threadstats',
        'datadog.util',
        'tests',
        'tests.integration',
        'tests.integration.api',
        'tests.integration.dogshell',
        'tests.performance',
        'tests.unit',
        'tests.unit.api',
        'tests.unit.dogstatsd',
        'tests.unit.dogwrap',
        'tests.unit.threadstats',
        'tests.unit.util',
        'tests.util',
    ],
)
